#! /bin/bash
#
# This example demonstrates how to call repo-admin.py
# You will need to call repo-admin.py with your download url if the url shown below differs.
# Basic auth username and password is supported in the url.
#
# You can customitze the main html file and re-run repo-admin.py later.
# For a server without https support use --insecure --url http://...
#

# enable error handling before everything else to make sure even the cd call works
set -euxo pipefail

cd "$(dirname "${0}")"

opt=()

# if a .repo-admin-prefix file is found in a parent directory, --url can be omitted
opt+=("--url" "http://USER:PASS@www.example.com/download")

python3 bin/repo-admin.py --insecure "${opt[@]}" -d 'download' -p '.*-client' -i 'index.html' -f ..
